/* - MCAttachListener -
 * populate the fields and controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

/**
 *
 * @author Owner
 */
public class MCAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numMotorsTxt;
    private JTextField numInTxt;
    private JTextField currVelTxt;
    private JTextField maxVelTxt;
    private JTextField accelTxt;
    private JTextField currentTxt;
    private JComboBox motorCmb;
    private JSlider maxVelScrl;
    private JSlider accelScrl;
    private JCheckBox inputArray[];
    private JLabel jLabel10;
    
    /** Creates a new instance of MCAttachListener */
    public MCAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt, 
            JTextField serialTxt, JTextField versionTxt, JTextField numMotorsTxt, JTextField numInTxt,
            JTextField currVelTxt, JTextField maxVelTxt, JTextField accelTxt, 
            JLabel jLabel10, JTextField currentTxt, JComboBox motorCmb, JSlider maxVelScrl, 
            JSlider accelScrl, JCheckBox inputArray[])
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numMotorsTxt = numMotorsTxt;
        this.numInTxt = numInTxt;
        this.currVelTxt = currVelTxt;
        this.maxVelTxt = maxVelTxt;
        this.accelTxt = accelTxt;
        this.jLabel10 = jLabel10;
        this.currentTxt = currentTxt;
        this.motorCmb = motorCmb;
        this.maxVelScrl = maxVelScrl;
        this.accelScrl = accelScrl;
        this.inputArray = inputArray;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            MotorControlPhidget attached = (MotorControlPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numMotorsTxt.setText(Integer.toString(attached.getMotorCount()));
            numInTxt.setText(Integer.toString(attached.getInputCount()));
            
            //The minimum acceleration for a motor is 1, the maximum is 100
            accelScrl.setMaximum((int)attached.getAccelerationMax(0));
            accelScrl.setMinimum((int)attached.getAccelerationMin(0)+1);
            accelScrl.setValue((int)attached.getAccelerationMin(0));
        
            int i;
            
            for(i = 0; i < attached.getMotorCount(); i++)
            {
                motorCmb.addItem(new Integer(i));
            }
            
            motorCmb.setSelectedIndex(0);
            
            motorCmb.setEnabled(true);
            
            for(i = 0; i < attached.getInputCount(); i++)
            {
                inputArray[i].setVisible(true);
            }
            
            if(attached.getDeviceName().compareTo("Phidget Low Voltage Motor Controller 2-motor 4-input") == 0)
            {
                jLabel10.setVisible(false);
                currentTxt.setVisible(false);  
            }
            else
            {
                jLabel10.setVisible(true);
                currentTxt.setVisible(true);
            }
            
            maxVelScrl.setEnabled(true);
            accelScrl.setEnabled(true);
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
